
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BOT CLUB</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;700&family=Roboto+Mono:wght@700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #00ffc8;
            --secondary-color: #00aaff;
            --accent-red: #ff3366;
            --accent-yellow: #FFD700;
            --dark-bg: #0e0e0e;
            --card-bg: #1f1f1f;
            --header-bg: #2c2c2e;
            --text-primary: #ffffff;
            --text-secondary: #a9a9b3;
            --gradient-primary: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            --gradient-danger: linear-gradient(135deg, #ff3366, #ff6b8b);
            --gradient-success: linear-gradient(135deg, #4CAF50, #81C784);
        }
    </style>
</head>
<body>
    <div class="container" style="display: none;">
        <header class="header">
            <h1>BOT CLUB</h1>
            <div class="balance-section">
                <span>Balance: ৳</span>
                <span id="user-balance">0.00</span>
                <button id="refresh-balance-btn" title="Refresh Balance">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="23 4 23 10 17 10"></polyline><path d="M20.49 15a9 9 0 1 1-2.12-9.36L23 10"></path></svg>
                </button>
            </div>
        </header>

        <div class="notice-bar">
            <div class="notice-content" id="notice-content">
                </div>
        </div>

<div class="nav-tabs">
    <button class="nav-tab active" data-page="home">
        <i class="fas fa-home"></i> Home
    </button>
    <button class="nav-tab" data-page="wallet">
        <i class="fas fa-wallet"></i> Wallet
    </button>
    <button class="nav-tab" data-page="profile">
        <i class="fas fa-user"></i> Profile
    </button>
</div>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">


        <div id="home-page" class="page-content active">
            <main class="game-container">
                <div id="timer-overlay">
                    <span id="overlay-countdown-text"></span>
                </div>

                <section class="timer-section">
                    <div class="timer-info">
                        <div>
                            <h2>WinGo 1 Min</h2>
                            <p>Period: <span id="currentPeriod">Loading...</span></p>
                        </div>
                        <div>
                            <p>Time Remaining</p>
                            <div id="countdown">00:00</div>
                        </div>
                    </div>
                </section>

<div class="betting-area">
    <section class="betting-options">
        <button class="btn btn-green" data-bet-type="Green">Green</button>
        <button class="btn btn-violet" data-bet-type="Violet">Violet</button>
        <button class="btn btn-red" data-bet-type="Red">Red</button>
    </section>

    <section class="number-grid">

        <button class="btn num img0" data-bet-type=""></button>
        <button class="btn num img1" data-bet-type=""></button>
        <button class="btn num img2" data-bet-type=""></button>
        <button class="btn num img3" data-bet-type=""></button>
        <button class="btn num img4" data-bet-type=""></button>
        <button class="btn num img5" data-bet-type=""></button>
        <button class="btn num img6" data-bet-type=""></button>
        <button class="btn num img7" data-bet-type=""></button>
        <button class="btn num img8" data-bet-type=""></button>
        <button class="btn num img9" data-bet-type=""></button>

    </section>

    <section class="size-options">
        <button class="btn btn-big" data-bet-type="Big">Big</button>
        <button class="btn btn-small" data-bet-type="Small">Small</button>
    </section>
</div>

            </main>

            <div class="tabs">
                <button class="tab-btn active" data-tab="game-history">Game History</button>
                <button class="tab-btn" data-tab="my-history">My History</button>
            </div>

            <div id="game-history-panel" class="tab-panel active">
                <div class="history-container">
                    <table>
                        <thead>
                            <tr><th>Period</th><th>Number</th><th>Big/Small</th><th>Color</th></tr>
                        </thead>
                        <tbody id="resultBody"></tbody>
                    </table>
                </div>
            </div>

            <div id="my-history-panel" class="tab-panel">
                <div class="history-container">
                    <table id="my-history-table">
                        <thead>
                            <tr><th>Period</th><th>Bet</th><th>Amount</th><th>Result</th></tr>
                        </thead>
                        <tbody id="myHistoryBody"></tbody>
                    </table>
                </div>
            </div>
        </div>

        <div id="wallet-page" class="page-content">
            <div class="page-header">
                <button class="back-btn" onclick="navigateToPage('home')"><i class="fas fa-arrow-left"></i></button>
                <h2 class="page-title">Wallet</h2>
            </div>
            <div class="wallet-card">
                <div class="wallet-balance">
                    <h2>Available Balance</h2>
                    <p>৳<span id="wallet-balance-total">0.00</span></p>
                    <div class="balance-breakdown">
                         <div>
                            <h3>Deposit</h3>
                            <p>৳<span id="wallet-balance-deposit">0.00</span></p>
                        </div>
                        <div>
                            <h3>Winning</h3>
                            <p>৳<span id="wallet-balance-winning">0.00</span></p>
                        </div>
                    </div>
                </div>
                <div class="wallet-actions">
                    <button class="wallet-action-btn deposit-btn" onclick="navigateToPage('deposit-select')">
                        <i class="fas fa-arrow-down"></i> Deposit
                    </button>
                    <button class="wallet-action-btn withdraw-btn" id="withdraw-nav-btn">
                        <i class="fas fa-arrow-up"></i> Withdraw
                    </button>
                </div>
            </div>

            <div class="transaction-history">
                <h3>Transaction History</h3>
                <div class="transaction-history-list" id="transaction-list">
                    </div>
            </div>
        </div>
        
        <div id="deposit-select-page" class="page-content">
             <div class="page-header">
                <button class="back-btn" onclick="navigateToPage('wallet')"><i class="fas fa-arrow-left"></i></button>
                <h2 class="page-title">Deposit</h2>
            </div>
            <div class="payment-tabs">
                <div class="payment-tab active" id="bkash-tab" onclick="switchPaymentMethod('bKash')">bKash</div>
                <div class="payment-tab" id="nagad-tab" onclick="switchPaymentMethod('Nagad')">Nagad</div>
            </div>
            <div class="deposit-notice">
                এই অ্যাপে ডিপোজিট করার জন্য অবশ্যই <strong>সেন্ড মানি</strong> করতে হবে।
            </div>
             <div id="payment-number-container">
                <p>Loading payment numbers...</p>
            </div>
            <div class="form-group">
                <label for="deposit-amount-input">টাকার পরিমাণ</label>
                <input type="number" id="deposit-amount-input" placeholder="Enter amount">
                <div class="amount-quick-select" id="amount-quick-select">
                    </div>
            </div>
            <button class="submit-btn" id="deposit-next-btn">Next</button>
        </div>
        
        <div id="deposit-confirm-page" class="page-content">
            <div class="page-header">
                <button class="back-btn" onclick="navigateToPage('deposit-select')"><i class="fas fa-arrow-left"></i></button>
                <h2 class="page-title">Confirm Deposit</h2>
            </div>
             <div class="confirmation-box">
                <div class="label">অনুগ্রহ করে নিচের <span id="payment-method-label">bKash</span> পার্সোনাল নাম্বারে 'সেন্ড মানি' করুন এবং সঠিক TxnID পূরণ করুন।</div>
                <div class="label" style="color: var(--accent-red); margin-top: 10px;">ক্যাশ আউট ব্যবহার না করে সেন্ড মানি করুন</div>
                
                <p style="margin: 15px 0;">ওয়ালেট</p>
                 <div class="value-box">
                    <span class="value" id="confirm-payment-number">...</span>
                    <button class="copy-btn" id="copy-payment-number-btn"><i class="fas fa-copy"></i></button>
                </div>

                <p style="margin: 15px 0;">পরিমাণ</p>
                 <div class="value-box">
                    <span class="value" id="confirm-payment-amount">৳0</span>
                </div>
                 
                <div class="form-group" style="text-align: left;">
                    <label for="txn-id-input">রিচার্জ সম্পূর্ণ করতে অনুগ্রহ করে লেনদেন আইডি লিখুন</label>
                    <input type="text" id="txn-id-input" placeholder="Enter Transaction ID">
                </div>
                
                <button class="submit-btn" id="confirm-deposit-submit-btn">জমা দিন</button>
            </div>
        </div>

        <div id="withdraw-page" class="page-content">
             <div class="page-header">
                <button class="back-btn" onclick="navigateToPage('wallet')"><i class="fas fa-arrow-left"></i></button>
                <h2 class="page-title">Withdraw</h2>
            </div>
            <div class="wallet-card">
                 <div class="wallet-balance" style="margin-bottom: 25px;">
                    <h2>Available for Withdrawal</h2>
                    <p>৳<span id="withdrawal-available-balance">0.00</span></p>
                </div>
                <p>আপনার উইথড্রয়ালের পরিমাণ এবং বিবরণ লিখুন:</p>
                <small>আপনি শুধুমাত্র উইনিং ব্যালেন্স থেকে টাকা তুলতে পারবেন।</small>
                <div class="form-group">
                    <label for="withdraw-amount">Amount</label>
                    <input type="number" id="withdraw-amount" placeholder="Amount">
                </div>
                <div class="form-group">
                    <label for="withdraw-method">Payment Method</label>
                    <input type="text" id="withdraw-method" placeholder="bKash, Nagad, etc.">
                </div>
                <div class="form-group">
                    <label for="withdraw-account">Account Number</label>
                    <input type="text" id="withdraw-account" placeholder="Your account number">
                </div>
                <button class="submit-btn" id="withdraw-submit-btn">Submit Request</button>
            </div>
        </div>


        <div id="profile-page" class="page-content">
            <div class="profile-card">
                <div class="profile-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div class="profile-info">
                    <h2 id="user-name">User Name</h2>
                    <p>ID: <span id="user-id">...</span></p>
                    <p>Phone: <span id="user-phone">...</span></p>
                </div>
            </div>
            <div class="profile-menu-list">
                 <div class="profile-menu-item" onclick="navigateToPage('wallet')">
                    <i class="fas fa-wallet"></i>
                    <span>Wallet</span>
                </div>
                <div class="profile-menu-item" onclick="navigateToPage('referral')">
                    <i class="fas fa-user-friends"></i>
                    <span>Referral</span>
                </div>
                <div class="profile-menu-item" onclick="navigateToPage('bonus')">
                    <i class="fas fa-gift"></i>
                    <span>Gift Code</span>
                </div>
                 <div class="profile-menu-item" onclick="navigateToPage('settings')">
                    <i class="fas fa-cog"></i>
                    <span>Settings</span>
                </div>
                <!-- UPDATED: Changed to Download App -->
                <div class="profile-menu-item" id="profile-download-btn">
                    <i class="fas fa-download"></i>
                    <span>Download App</span>
                </div>
            </div>
             <button class="submit-btn" id="logout-btn" style="background: var(--gradient-danger); margin-top: 20px;">
                <i class="fas fa-sign-out-alt"></i> Logout
            </button>
        </div>

        <div id="referral-page" class="page-content">
            <div class="page-header">
                <button class="back-btn" onclick="navigateToPage('profile')"><i class="fas fa-arrow-left"></i></button>
                <h2 class="page-title">Referral</h2>
            </div>
            <div class="referral-card">
                <h2>Your Referral Code</h2>
                <div class="referral-code-container">
                    <div class="referral-code" id="referral-code">...</div>
                    <button class="copy-btn" id="copy-referral-btn">
                        <i class="fas fa-copy"></i> Copy
                    </button>
                </div>
                <p>Share this code with your friends and earn bonus when they register!</p>
            </div>

            <div class="referral-stats">
                <div class="stat-card">
                    <div class="stat-value" id="referral-count">0</div>
                    <div class="stat-label">Total Referrals</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value" id="referral-bonus">৳0</div>
                    <div class="stat-label">Total Bonus</div>
                </div>
            </div>
        </div>

        <div id="bonus-page" class="page-content">
             <div class="page-header">
                <button class="back-btn" onclick="navigateToPage('profile')"><i class="fas fa-arrow-left"></i></button>
                <h2 class="page-title">Gift </h2>
            </div>
            <div class="gift-code-card">
                <h2>Redeem Gift Code</h2>
                <div class="gift-code-form">
                    <div class="form-group">
                        <label for="gift-code-input-field">Enter Gift Code</label>
                        <input type="text" id="gift-code-input-field" placeholder="Enter your gift code here">
                    </div>
                    <button class="submit-btn" id="redeem-gift-btn">Redeem</button>
                </div>
            </div>
        </div>

        <div id="settings-page" class="page-content">
             <div class="page-header">
                <button class="back-btn" onclick="navigateToPage('profile')"><i class="fas fa-arrow-left"></i></button>
                <h2 class="page-title">Settings</h2>
            </div>
            <div class="profile-card">
                <h2>Change Password</h2>
                <div class="auth-form">
                    <div class="form-group">
                        <label for="current-password">Current Password</label>
                        <input type="password" id="current-password" placeholder="Current Password">
                    </div>
                     <div class="form-group">
                        <label for="new-password">New Password</label>
                        <input type="password" id="new-password" placeholder="New Password">
                    </div>
                     <div class="form-group">
                        <label for="confirm-new-password">Confirm New Password</label>
                        <input type="password" id="confirm-new-password" placeholder="Confirm New Password">
                    </div>
                    <button class="submit-btn" id="change-password-btn">Update Password</button>
                </div>
            </div>
        </div>
    </div>


    <div class="popup-overlay" id="bet-popup">
        <div class="popup-content bet-popup-content">
            <h3 id="bet-popup-title">Place Bet on <span>...</span></h3>
            <div class="bet-popup-balance">
                Available: <span>৳</span><span id="bet-popup-current-balance">0.00</span>
            </div>
            <p>আপনার বেটের পরিমাণ লিখুন:</p>
            <div class="bet-input-container">
                <span>৳</span>
                <input type="number" id="bet-amount" placeholder="Amount" min="1">
            </div>
            <div class="bet-quick-select">
                <button data-add="10">+10</button>
                <button data-add="50">+50</button>
                <button data-add="100">+100</button>
                <button data-multiply="2">x2</button>
            </div>
            <div class="popup-buttons">
                <button id="btn-cancel">Cancel</button>
                <button id="btn-confirm">Confirm</button>
            </div>
        </div>
        </div>

    <div class="popup-overlay" id="result-popup">
        <div class="result-popup-content" id="result-popup-content">
            <div id="win-content">
                <h2 id="win-title">Congratulations</h2>
                <p id="win-subtitle">You Won</p>
                <div id="winnings-amount" data-text=""></div>
            </div>
            <div id="loss-content">
                <img id="loss-image" src="https://cdn-icons-png.flaticon.com/512/10436/10436979.png" alt="Loss">
                <h2 id="loss-title">Sorry!</h2>
                <p id="loss-message"></p>
            </div>
            <button class="btn-close" id="btn-close-result">OK</button>
        </div>
    </div>

    <div class="popup-overlay" id="alert-popup">
        <div class="popup-content" id="alert-popup-content">
            <h3 id="alert-title"></h3>
            <p id="alert-message"></p>
            <button id="btn-alert-ok">OK</button>
        </div>
    </div>

    <div class="auth-container" id="auth-container">
        <div class="auth-card">
            <div class="auth-logo">
                <h1>BOT CLUB</h1>
                <p>Your Trusted Betting Platform</p>
            </div>

            <div class="auth-tabs">
                <button class="auth-tab active" data-auth="login">Login</button>
                <button class="auth-tab" data-auth="register">Register</button>
            </div>

            <form id="login-form" class="auth-form">
                <div class="form-group">
                    <label for="login-phone">Phone Number</label>
                    <input type="tel" id="login-phone" placeholder="Enter your phone number" required>
                </div>
                <div class="form-group">
                    <label for="login-password">Password</label>
                    <input type="password" id="login-password" placeholder="Enter your password" required>
                </div>
                 <div class="checkbox-group">
                    <input type="checkbox" id="remember-me">
                    <label for="remember-me">রিমেম্বার মি</label>
                </div>
                <button type="submit" class="submit-btn">Login</button>
            </form>

            <form id="register-form" class="auth-form" style="display: none;">
                <div class="form-group">
                    <label for="register-name">Full Name</label>
                    <input type="text" id="register-name" placeholder="Enter your full name" required>
                </div>
                <div class="form-group">
                    <label for="register-phone">Phone Number</label>
                    <input type="tel" id="register-phone" placeholder="Enter your phone number" required>
                </div>
                <div class="form-group">
                    <label for="register-password">Password</label>
                    <input type="password" id="register-password" placeholder="Enter your password" required>
                </div>
                <div class="form-group">
                    <label for="register-confirm-password">Confirm Password</label>
                    <input type="password" id="register-confirm-password" placeholder="Confirm your password" required>
                </div>
                <div class="form-group">
                    <label for="referral-code-input">Referral Code (Optional)</label>
                    <input type="text" id="referral-code-input" placeholder="Enter referral code if you have one">
                </div>
                <button type="submit" class="submit-btn">Register</button>
            </form>
        </div>
    </div>
    
    <a id="support-link" href="#" target="_blank" class="floating-support-btn">
        <i class="fas fa-headset"></i>
    </a>

    <script src="https://www.gstatic.com/firebasejs/9.15.0/firebase-app-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.15.0/firebase-auth-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.15.0/firebase-database-compat.js"></script>

    <script>
        // --- আপনার Firebase কনফিগারেশন এখানে যোগ করুন ---
        const firebaseConfig = {
          apiKey: "AIzaSyCENZrZOnuGv6O68zGHPLaxdLRJAOgpIWg",
          authDomain: "chack-de478.firebaseapp.com",
          databaseURL: "https://chack-de478-default-rtdb.firebaseio.com",
          projectId: "chack-de478",
          storageBucket: "chack-de478.firebasestorage.app",
          messagingSenderId: "590212052078",
          appId: "1:590212052078:web:cca4fd99de918b569fa27f",
          measurementId: "G-DBQWV3X5VD"
        };

        firebase.initializeApp(firebaseConfig);
        const auth = firebase.auth();
        const database = firebase.database();

        // --- DOM Elements ---
        const authContainer = document.getElementById('auth-container');
        const mainContainer = document.querySelector('.container');
        const allNavTabs = document.querySelectorAll('.nav-tab');
        const allPageContents = document.querySelectorAll('.page-content');
        const authTabs = document.querySelectorAll('.auth-tab');
        const loginForm = document.getElementById('login-form');
        const registerForm = document.getElementById('register-form');
        const logoutBtn = document.getElementById('logout-btn');
        const copyReferralBtn = document.getElementById('copy-referral-btn');
        const redeemGiftBtn = document.getElementById('redeem-gift-btn');
        const changePasswordBtn = document.getElementById('change-password-btn');
        const profileDownloadBtn = document.getElementById('profile-download-btn');
        
        // Betting Game Elements
        const HISTORY_API = 'https://draw.ar-lottery01.com/WinGo/WinGo_1M/GetHistoryIssuePage.json';
        const allBettingButtons = document.querySelectorAll('.betting-area .btn');
        const balanceElements = {
            total: document.getElementById('user-balance'),
            walletTotal: document.getElementById('wallet-balance-total'),
            walletDeposit: document.getElementById('wallet-balance-deposit'),
            walletWinning: document.getElementById('wallet-balance-winning')
        };
        const countdownElement = document.getElementById('countdown');
        const betPopup = document.getElementById('bet-popup');
        const betAmountInput = document.getElementById('bet-amount');
        const confirmBtn = document.getElementById('btn-confirm');
        const cancelBtn = document.getElementById('btn-cancel');
        const resultPopup = document.getElementById('result-popup');
        const resultPopupContent = document.getElementById('result-popup-content');
        const closeResultBtn = document.getElementById('btn-close-result');
        const alertPopup = document.getElementById('alert-popup');
        const alertOkBtn = document.getElementById('btn-alert-ok');
        const historyTabButtons = document.querySelectorAll('.tabs .tab-btn');
        const historyTabPanels = document.querySelectorAll('.tab-panel');
        const timerOverlay = document.getElementById('timer-overlay');
        const overlayCountdownText = document.getElementById('overlay-countdown-text');
        const bettingArea = document.querySelector('.betting-area');
        const refreshBtn = document.getElementById('refresh-balance-btn');
        
        // Deposit/Withdrawal Elements
        const depositNextBtn = document.getElementById('deposit-next-btn');
        const confirmDepositSubmitBtn = document.getElementById('confirm-deposit-submit-btn');
        const copyPaymentNumberBtn = document.getElementById('copy-payment-number-btn');
        const withdrawNavBtn = document.getElementById('withdraw-nav-btn');
        const withdrawSubmitBtn = document.getElementById('withdraw-submit-btn');


        // --- Global State ---
        let currentUser = null;
        let currentUserData = {};
        let currentBetType = '';
        let timerInterval;
        let activeBet = null;
        let currentPeriodForBet = null;
        let depositState = {
            method: 'bKash',
            selectedNumber: null,
            amount: 0
        };
        let appSettings = {};
        let depositListener = null; 
        let myHistoryListener = null; // To hold the history listener

        // --- Authentication ---
        auth.onAuthStateChanged(user => {
            if (user) {
                currentUser = user;
                initializeUserSession();
                authContainer.style.display = 'none';
                mainContainer.style.display = 'flex';
            } else {
                currentUser = null;
                currentUserData = {};
                authContainer.style.display = 'flex';
                mainContainer.style.display = 'none';
                document.getElementById('support-link').style.display = 'none';
                if(timerInterval) clearInterval(timerInterval);
                // Detach listeners on logout to prevent memory leaks
                if (depositListener) depositListener.off();
                if (myHistoryListener) myHistoryListener.off();
            }
        });

        function initializeUserSession() {
            if (!currentUser) return;
            listenToUserData();
            listenForApprovedDeposits();
            listenAndRenderMyHistory(); // Set up real-time history updates upon login
            loadAppSettings();
            loadNotice();
            loadTransactionHistory();
            handleNewRound();
            startTimer();
        }
        
        // --- Data Handling ---
        function listenToUserData() {
            database.ref('users/' + currentUser.uid).on('value', (snapshot) => {
                if (snapshot.exists()) {
                    currentUserData = snapshot.val();
                    updateUIWithUserData(currentUserData);
                    
                    // --- NEW: Check for suspended status on data load ---
                    if (currentUserData.status === 'suspended') {
                        // Disable all betting and navigation if suspended
                        allBettingButtons.forEach(btn => btn.disabled = true);
                        allNavTabs.forEach(tab => tab.disabled = true);
                        bettingArea.style.opacity = '0.3';
                        bettingArea.title = 'আপনার অ্যাকাউন্টটি সাসপেন্ড করা হয়েছে।';
                    } else {
                        // Re-enable controls if status is not suspended (e.g., active)
                        allNavTabs.forEach(tab => tab.disabled = false);
                        const hasDeposited = currentUserData.hasDeposited || false;
                        allBettingButtons.forEach(btn => {
                            btn.disabled = !hasDeposited;
                        });
                        bettingArea.style.opacity = hasDeposited ? '1' : '0.5';
                        if (!hasDeposited) {
                            bettingArea.title = 'বেটিং করতে প্রথমে ডিপোজিট করুন';
                        } else {
                            bettingArea.title = '';
                        }
                    }
                }
            }, (error) => {
                console.error("Error listening to user data:", error);
                showAlert('Failed to load user data.', 'Error', 'error');
            });
        }
        
        function listenForApprovedDeposits() {
            if (!currentUser) return;
            if (depositListener) depositListener.off();

            const userDepositsRef = database.ref('deposits').orderByChild('uid').equalTo(currentUser.uid);
            
            const processDeposit = (snapshot) => {
                const depositData = snapshot.val();
                if (depositData.status === 'approved' && !currentUserData.hasDeposited) {
                    database.ref('users/' + currentUser.uid).update({ hasDeposited: true })
                        .then(() => {
                            console.log('User status updated to hasDeposited=true');
                            showAlert('আপনার ডিপোজিট সফল হয়েছে! আপনি এখন বেট এবং উইথড্র করতে পারবেন।', 'অভিনন্দন', 'success');
                        });
                }
            };

            userDepositsRef.on('child_added', processDeposit);
            userDepositsRef.on('child_changed', processDeposit);
            
            depositListener = userDepositsRef;
        }

        async function createUserProfile(user, name, phone, password, referredBy = null) {
            const uiId = Math.floor(100000 + Math.random() * 900000).toString();
            
            let welcomeBonus = 0;
            try {
                const settingsSnapshot = await database.ref('settings/welcomeBonus').once('value');
                if (settingsSnapshot.exists()) {
                    welcomeBonus = settingsSnapshot.val();
                }
            } catch (e) {
                console.warn("Could not fetch welcome bonus setting", e);
                welcomeBonus = 0;
            }

            const userData = {
                uid: user.uid,
                uiId: uiId,
                name: name,
                phone: phone,
                password: password,
                depositBalance: welcomeBonus,
                winningBalance: 0,
                totalReferrals: 0,
                totalBonus: 0,
                usedReferralCode: referredBy || null,
                createdAt: firebase.database.ServerValue.TIMESTAMP,
                hasDeposited: false,
                status: 'active' // Default status is active
            };

            await database.ref('users/' + user.uid).set(userData);

            if(referredBy) {
                const referrerRef = database.ref('users').orderByChild('uiId').equalTo(referredBy);
                referrerRef.once('value', snapshot => {
                    if(snapshot.exists()){
                        snapshot.forEach(childSnapshot => {
                            const referrerUserRef = database.ref('users/' + childSnapshot.key);
                            referrerUserRef.child('referralCount').transaction(count => (count || 0) + 1);
                        });
                    }
                });
            }
        }
        
        function loadAppSettings() {
             database.ref('settings').on('value', (snapshot) => {
                if(snapshot.exists()){
                    appSettings = snapshot.val();
                    const quickAmounts = [100, 500, 1000, 5000, 10000, 20000];
                    const quickSelectContainer = document.getElementById('amount-quick-select');
                    quickSelectContainer.innerHTML = '';
                    quickAmounts.forEach(amount => {
                        const btn = document.createElement('button');
                        btn.className = 'amount-btn';
                        btn.textContent = `৳${amount}`;
                        btn.onclick = () => {
                            document.getElementById('deposit-amount-input').value = amount;
                        };
                        quickSelectContainer.appendChild(btn);
                    });
                    
                    // Floating Support Button
                    const supportLinkEl = document.getElementById('support-link');
                    if (appSettings.supportLink) {
                        supportLinkEl.href = appSettings.supportLink;
                        supportLinkEl.style.display = 'flex';
                    } else {
                        supportLinkEl.style.display = 'none';
                    }
                    // The 'appDownloadLink' is handled by a separate event listener on the button.
                }
            });
        }

        function loadNotice() {
            const staticNotice = "স্বাগতম! 💖 সর্বনিম্ন ৫০ টাকা ডিপোজিট করুন। প্রথমবার ৮০ টাকা ডিপোজিট করলেই ২০ টাকা বোনাস! 🎁 ";
            const noticeEl = document.getElementById('notice-content');
            
            database.ref('settings/notice').on('value', (snapshot) => {
                let dynamicNotice = "";
                if(snapshot.exists()){
                    dynamicNotice = snapshot.val();
                }
                noticeEl.textContent = staticNotice + " --- " + dynamicNotice + " --- " + staticNotice;
            });
        }

        function loadTransactionHistory() {
            const listEl = document.getElementById('transaction-list');
            listEl.innerHTML = '';
            const uid = currentUser.uid;

            const renderList = (label, items) => {
                 if (!items) return;
                 Object.values(items).sort((a,b) => b.createdAt - a.createdAt).forEach(item => {
                     const el = document.createElement('div');
                     el.className = 'transaction-item';
                     el.innerHTML = `
                         <div class="transaction-info">
                             <div class="transaction-type">${label} (${item.status || '...'})</div>
                             <div class="transaction-date">${new Date(item.createdAt).toLocaleString()}</div>
                         </div>
                         <div class="transaction-amount ${label.includes('Deposit') ? 'credit' : 'debit'}">
                             ${label.includes('Deposit') ? '+' : '-'}৳${item.amount.toFixed(2)}
                         </div>`;
                     listEl.appendChild(el);
                 });
            };
            
            database.ref('deposits').orderByChild('uid').equalTo(uid).limitToLast(10).on('value', s => renderList('Deposit', s.val()));
            database.ref('withdrawals').orderByChild('uid').equalTo(uid).limitToLast(10).on('value', s => renderList('Withdrawal', s.val()));
        }

        // --- UI Updates ---
        function updateUIWithUserData(userData) {
            document.getElementById('user-name').textContent = userData.name || 'User';
            document.getElementById('user-id').textContent = userData.uiId || '...';
            document.getElementById('user-phone').textContent = userData.phone || '...';
            document.getElementById('referral-code').textContent = userData.uiId || '...';
            
            document.getElementById('referral-count').textContent = userData.totalReferrals || 0;
            document.getElementById('referral-bonus').textContent = `৳${(userData.totalBonus || 0).toFixed(2)}`;
            
            const depositBalance = userData.depositBalance || 0;
            const winningBalance = userData.winningBalance || 0;
            const total = depositBalance + winningBalance;

            balanceElements.total.textContent = total.toFixed(2);
            balanceElements.walletTotal.textContent = total.toFixed(2);
            balanceElements.walletDeposit.textContent = depositBalance.toFixed(2);
            balanceElements.walletWinning.textContent = winningBalance.toFixed(2);

            const withdrawalAvailableEl = document.getElementById('withdrawal-available-balance');
            if(withdrawalAvailableEl) {
                withdrawalAvailableEl.textContent = winningBalance.toFixed(2);
            }
        }

        function showAlert(message, title = 'Alert', type = 'info') {
            document.getElementById('alert-title').textContent = title;
            document.getElementById('alert-message').textContent = message;
            const content = document.getElementById('alert-popup-content');
            content.className = 'popup-content';
            if (type === 'error') content.classList.add('error');
            alertPopup.style.display = 'flex';
        }

        // --- Navigation ---
        function navigateToPage(pageId) {
            allPageContents.forEach(content => content.classList.remove('active'));
            const targetPage = document.getElementById(`${pageId}-page`);
            if (targetPage) {
                targetPage.classList.add('active');
            } else {
                console.warn(`Page not found: ${pageId}-page`);
                document.getElementById('home-page').classList.add('active'); // Fallback to home
                pageId = 'home';
            }
            
            const mainPages = ['home', 'wallet', 'profile'];
            document.querySelector('.nav-tabs').style.display = mainPages.includes(pageId) ? 'flex' : 'none';

            allNavTabs.forEach(t => t.classList.remove('active'));
            if (mainPages.includes(pageId)) {
                 const correspondingTab = document.querySelector(`.nav-tab[data-page="${pageId}"]`);
                 if (correspondingTab) correspondingTab.classList.add('active');
            }
        }
        
        allNavTabs.forEach(tab => tab.addEventListener('click', () => navigateToPage(tab.dataset.page)));

        authTabs.forEach(tab => {
            tab.addEventListener('click', () => {
                authTabs.forEach(t => t.classList.remove('active'));
                tab.classList.add('active');
                loginForm.style.display = (tab.dataset.auth === 'login') ? 'flex' : 'none';
                registerForm.style.display = (tab.dataset.auth === 'register') ? 'flex' : 'none';
            });
        });

        // --- Event Listeners ---
        loginForm.addEventListener('submit', (e) => {
            e.preventDefault();
            const phone = document.getElementById('login-phone').value;
            const password = document.getElementById('login-password').value;
            const email = `${phone}@botclub.com`;
            auth.signInWithEmailAndPassword(email, password)
                .catch(error => {
                    let message = 'লগইন ব্যর্থ হয়েছে। অনুগ্রহ করে আবার চেষ্টা করুন।';
                    switch (error.code) {
                        case 'auth/user-not-found':
                        case 'auth/invalid-email':
                            message = 'এই ফোন নাম্বার দিয়ে কোনো অ্যাকাউন্ট খুঁজে পাওয়া যায়নি।';
                            break;
                        case 'auth/wrong-password':
                            message = 'আপনি ভুল পাসওয়ার্ড দিয়েছেন।';
                            break;
                        default:
                            message = 'একটি অজানা সমস্যা হয়েছে। অনুগ্রহ করে পরে চেষ্টা করুন।';
                            console.error("Login Error:", error);
                            break;
                    }
                    showAlert(message, 'লগইন ব্যর্থ', 'error');
                });
        });

        registerForm.addEventListener('submit', (e) => {
            e.preventDefault();
            const name = document.getElementById('register-name').value;
            const phone = document.getElementById('register-phone').value;
            const password = document.getElementById('register-password').value;
            const confirmPassword = document.getElementById('register-confirm-password').value;
            const referralCode = document.getElementById('referral-code-input').value.trim();
            
            if (password !== confirmPassword) {
                return showAlert('Passwords do not match.', 'Error', 'error');
            }
            if (password.length < 6) {
                 return showAlert('Password must be at least 6 characters.', 'Error', 'error');
            }

            const email = `${phone}@botclub.com`;
            auth.createUserWithEmailAndPassword(email, password)
                .then(userCredential => {
                    return createUserProfile(userCredential.user, name, phone, password, referralCode || null);
                })
                .then(() => showAlert('রেজিস্ট্রেশন সফল হয়েছে!', 'স্বাগতম'))
                .catch(error => {
                    let message = 'রেজিস্ট্রেশন ব্যর্থ হয়েছে। অনুগ্রহ করে আবার চেষ্টা করুন।';
                    switch (error.code) {
                        case 'auth/email-already-in-use':
                            message = 'এই ফোন নাম্বারটি ஏற்கனவே ব্যবহার করা হয়েছে।';
                            break;
                        case 'auth/invalid-email':
                            message = 'আপনার ফোন নাম্বারটি সঠিক নয়।';
                            break;
                        case 'auth/weak-password':
                            message = 'পাসওয়ার্ডটি খুবই দুর্বল। অনুগ্রহ করে আরও শক্তিশালী পাসওয়ার্ড দিন।';
                            break;
                        default:
                            message = 'একটি অজানা সমস্যা হয়েছে। অনুগ্রহ করে পরে চেষ্টা করুন।';
                            console.error("Register Error:", error);
                            break;
                    }
                    showAlert(message, 'রেজিস্ট্রেশন ব্যর্থ', 'error');
                });
        });

        logoutBtn.addEventListener('click', () => auth.signOut());

        copyReferralBtn.addEventListener('click', () => {
            const code = document.getElementById('referral-code').textContent;
            navigator.clipboard.writeText(code).then(() => showAlert('Referral code copied!', 'Success'));
        });
        
        profileDownloadBtn.addEventListener('click', () => {
            if (appSettings.appDownloadLink) {
                window.open(appSettings.appDownloadLink, '_blank');
            } else {
                showAlert('অ্যাপ ডাউনলোড লিঙ্ক এখনো সেট করা হয়নি।', 'দুঃখিত', 'error');
            }
        });

        redeemGiftBtn.addEventListener('click', () => {
            const code = document.getElementById('gift-code-input-field').value.trim();
            if (!code) return showAlert('Please enter a gift code.', 'Error', 'error');

            database.ref('giftCodes').orderByChild('code').equalTo(code).once('value', snapshot => {
                if (!snapshot.exists()) {
                    return showAlert('Invalid or expired gift code.', 'Error', 'error');
                }
                let codeId, codeData;
                snapshot.forEach(child => {
                    if (child.val().status === 'active') {
                        codeId = child.key;
                        codeData = child.val();
                    }
                });

                if (!codeId || !codeData) {
                    return showAlert('This code has already been used or is inactive.', 'Error', 'error');
                }

                database.ref('giftCodes/' + codeId).update({ status: 'redeemed', redeemedBy: currentUser.uid })
                    .then(() => {
                        return database.ref('users/' + currentUser.uid + '/depositBalance').transaction(balance => (balance || 0) + codeData.amount);
                    })
                    .then(() => {
                        showAlert(`Successfully redeemed ৳${codeData.amount}!`, 'Success');
                        document.getElementById('gift-code-input-field').value = '';
                    })
                    .catch(err => showAlert('Redemption failed: ' + err.message, 'Error', 'error'));
            });
        });
        
        changePasswordBtn.addEventListener('click', async () => {
            const currentPass = document.getElementById('current-password').value;
            const newPass = document.getElementById('new-password').value;
            const confirmPass = document.getElementById('confirm-new-password').value;

            if (!newPass || newPass.length < 6) {
                return showAlert('New password must be at least 6 characters long.', 'Error', 'error');
            }
            if (newPass !== confirmPass) {
                return showAlert('New passwords do not match.', 'Error', 'error');
            }

            try {
                const user = auth.currentUser;
                const cred = firebase.auth.EmailAuthProvider.credential(user.email, currentPass);
                await user.reauthenticateWithCredential(cred);
                
                await user.updatePassword(newPass);
                await database.ref('users/' + user.uid).update({ password: newPass });

                showAlert('Password updated successfully!', 'Success');
                 document.getElementById('current-password').value = '';
                 document.getElementById('new-password').value = '';
                 document.getElementById('confirm-new-password').value = '';
            } catch (error) {
                let message = 'পাসওয়ার্ড পরিবর্তন ব্যর্থ হয়েছে।';
                if (error.code === 'auth/wrong-password') {
                    message = 'আপনার বর্তমান পাসওয়ার্ডটি ভুল।';
                }
                showAlert(message, 'ব্যর্থ হয়েছে', 'error');
            }
        });


        // --- Betting Game Logic ---
        function getBigSmall(num) { return num >= 5 ? 'Big' : 'Small'; }
        function getColorList(num) {
            if ([1, 3, 7, 9].includes(num)) return ['Green'];
            if ([2, 4, 6, 8].includes(num)) return ['Red'];
            if (num === 5) return ['Green', 'Violet'];
            if (num === 0) return ['Red', 'Violet'];
            return [];
        }

        /**
         * UPDATED AND RELIABLE HISTORY FUNCTION
         * This function sets up a real-time listener for the user's betting history.
         * It automatically shows the last 20 bets and updates the table whenever a new bet is added or its result changes.
         */
     function listenAndRenderMyHistory() {
    if (!currentUser) return;

    // Remove previous listener if exists
    if (myHistoryListener) {
        myHistoryListener.off();
        myHistoryListener = null;
    }

    const myHistoryRef = database.ref(`bets/${currentUser.uid}`).orderByChild('timestamp').limitToLast(20);
    const myHistoryBody = document.getElementById('myHistoryBody');

    myHistoryListener = myHistoryRef.on('value', snapshot => {
        if (!snapshot.exists()) {
            myHistoryBody.innerHTML = '<tr><td colspan="4">আপনার কোনো বেটিং হিস্টোরি নেই।</td></tr>';
            return;
        }

        const history = [];
        snapshot.forEach(child => {
            const bet = child.val();
            history.push(bet); // Original structure maintained
        });

        history.reverse(); // Newest first

        myHistoryBody.innerHTML = history.map(bet => {
            const isWin = bet.outcome === 'Win';
            const outcomeClass = isWin ? 'outcome-win' : 'outcome-loss';
            
            const resultAmount = (bet.outcome === 'Pending') 
                ? 'Pending...' 
                : (isWin ? `+৳${bet.winnings.toFixed(2)}` : `-৳${bet.amount.toFixed(2)}`);

            const periodDisplay = bet.period ? `...${String(bet.period).slice(-4)}` : 'N/A';
            
            return `<tr>
                        <td>${periodDisplay}</td>
                        <td>${bet.type}</td>
                        <td>৳${bet.amount.toFixed(2)}</td>
                        <td class="${outcomeClass}">${resultAmount}</td>
                    </tr>`;
        }).join('');
    }, (error) => {
        console.error("Firebase history read error:", error);
        myHistoryBody.innerHTML = '<tr><td colspan="4">হিস্টোরি লোড করা যায়নি।</td></tr>';
    });
}

// --- loadHistory remains exactly the same as you gave ---
async function loadHistory() {
    try {
        const res = await fetch(HISTORY_API + '?ts=' + Date.now());
        const data = await res.json();
        const list = data.data.list.slice(0, 10);
        const tbody = document.getElementById('resultBody');
        tbody.innerHTML = list.map(item => {
            const num = parseInt(item.number);
            const colorClasses = getColorList(num).map(c => c.toLowerCase());
            return `<tr><td>${item.issueNumber}</td><td class="num ${colorClasses[0] || ''}">${num}</td><td>${getBigSmall(num)}</td><td>${colorClasses.map(c => `<span class="dot ${c}"></span>`).join(' ')}</td></tr>`;
        }).join('');
        return list;
    } catch (error) {
        console.error("Failed to load history:", error);
        document.getElementById('resultBody').innerHTML = '<tr><td colspan="4">Error loading history</td></tr>';
        return null;
    }
}

function showResultPopup(isWin, message) {
    resultPopupContent.classList.toggle('win', isWin);
    resultPopupContent.classList.toggle('loss', !isWin);
    if (isWin) {
        const winningsAmountDiv = document.getElementById('winnings-amount');
        winningsAmountDiv.textContent = message;
        winningsAmountDiv.setAttribute('data-text', message);
    } else {
        document.getElementById('loss-message').textContent = message;
    }
    resultPopup.style.display = 'flex';
}

async function processBetResult(winningNumber) {
    if (!activeBet || !activeBet.betId) return;

    const num = parseInt(winningNumber);
    const winningSize = getBigSmall(num);
    const winningColors = getColorList(num);
    let isWin = false;
    let payoutRate = 0;

    if (winningColors.includes(activeBet.type)) { isWin = true; payoutRate = activeBet.type === 'Violet' ? 4.5 : 2; }
    else if (activeBet.type === winningSize) { isWin = true; payoutRate = 2; }
    else if (parseInt(activeBet.type, 10) === num) { isWin = true; payoutRate = 9; }
    
    const betRecordRef = database.ref(`bets/${currentUser.uid}/${activeBet.betId}`);
    let updateData = {};

    if (isWin) {
        const winnings = activeBet.amount * payoutRate;
        database.ref('users/' + currentUser.uid + '/winningBalance').transaction(balance => (balance || 0) + winnings);
        showResultPopup(true, `৳${winnings.toFixed(2)}`);
        updateData = { outcome: 'Win', winnings: winnings };
    } else {
        showResultPopup(false, `The result was ${num}. Better luck next time!`);
        updateData = { outcome: 'Loss', winnings: 0 };
    }
    
    await betRecordRef.update(updateData);
    activeBet = null; // Clear the active bet for the next round
}

async function handleNewRound() {
    const history = await loadHistory();
    if (!history || history.length === 0) return;
    
    if (activeBet && BigInt(activeBet.period) === BigInt(history[0].issueNumber)) {
        await processBetResult(history[0].number);
    }
    
    try {
        currentPeriodForBet = BigInt(history[0].issueNumber) + 1n;
        document.getElementById('currentPeriod').innerText = currentPeriodForBet.toString();
    } catch (error) {
        document.getElementById('currentPeriod').innerText = "Error";
    }
}

        function startTimer() {
            clearInterval(timerInterval);
            timerInterval = setInterval(() => {
                const timeLeft = 59 - new Date().getSeconds();
                countdownElement.textContent = "00:" + String(timeLeft).padStart(2, '0');
                
                const isBettingClosed = timeLeft <= 5;
                const hasDeposited = currentUserData.hasDeposited || false;
                const isSuspended = currentUserData.status === 'suspended';
                
                allBettingButtons.forEach(btn => btn.disabled = isBettingClosed || !hasDeposited || isSuspended);
                bettingArea.style.opacity = (isBettingClosed || !hasDeposited || isSuspended) ? '0.5' : '1';
                timerOverlay.style.display = isBettingClosed ? 'flex' : 'none';
                
                if (isBettingClosed) {
                    overlayCountdownText.textContent = timeLeft;
                    if (betPopup.style.display === 'flex') {
                        betPopup.style.display = 'none';
                        showAlert('সময় শেষ, এই রাউন্ডে আর বেট করা যাবে না।', 'দুঃখিত', 'error');
                    }
                }

                if (timeLeft <= 0) {
                    clearInterval(timerInterval);
                    countdownElement.textContent = "00:00";
                    setTimeout(handleNewRound, 1000);
                    setTimeout(startTimer, 2000);
                }
            }, 1000);
        }

        allBettingButtons.forEach(button => {
            button.addEventListener('click', () => {
                currentBetType = button.dataset.betType;
                
                const titleSpan = document.querySelector('#bet-popup-title span');
                titleSpan.textContent = currentBetType;
                
                if (currentBetType === 'Green') titleSpan.style.color = '#57c55b';
                else if (currentBetType === 'Red') titleSpan.style.color = '#f44336';
                else if (currentBetType === 'Violet') titleSpan.style.color = '#a941c4';
                else titleSpan.style.color = 'var(--primary-color)';
                
                const totalBal = (currentUserData.depositBalance || 0) + (currentUserData.winningBalance || 0);
                document.getElementById('bet-popup-current-balance').textContent = totalBal.toFixed(2);
                
                betPopup.style.display = 'flex';
                betAmountInput.value = '';
                betAmountInput.focus();
            });
        });
        
        document.querySelector('.bet-quick-select').addEventListener('click', (e) => {
            if (e.target.tagName !== 'BUTTON') return;
            
            let currentAmount = parseFloat(betAmountInput.value) || 0;
            
            if (e.target.dataset.add) {
                currentAmount += parseFloat(e.target.dataset.add);
            } else if (e.target.dataset.multiply) {
                currentAmount *= parseFloat(e.target.dataset.multiply);
            }
            
            betAmountInput.value = Math.max(0, currentAmount).toFixed(0);
        });

        cancelBtn.addEventListener('click', () => betPopup.style.display = 'none');
        
        confirmBtn.addEventListener('click', async () => {
            const amount = parseFloat(betAmountInput.value);
            if (isNaN(amount) || amount <= 0) return showAlert('সঠিক পরিমাণ লিখুন।', 'Error', 'error');
            if (activeBet) return showAlert('আপনি এই রাউন্ডে ইতোমধ্যে একটি বেট করেছেন।', 'Error', 'error');
            
            const userRef = database.ref('users/' + currentUser.uid);
            try {
                const transactionResult = await userRef.transaction(userData => {
                    if (!userData) return; 
                    
                    let depositBal = userData.depositBalance || 0;
                    let winningBal = userData.winningBalance || 0;

                    if ((depositBal + winningBal) < amount) {
                        return; 
                    }
                    
                    if(depositBal >= amount) {
                        userData.depositBalance -= amount;
                    } else {
                        const remainingAmount = amount - depositBal;
                        userData.depositBalance = 0;
                        userData.winningBalance -= remainingAmount;
                    }
                    return userData;
                });

                if (transactionResult.committed) {
                    const newBetRef = database.ref(`bets/${currentUser.uid}`).push();
                    const betData = {
                        betId: newBetRef.key,
                        type: currentBetType,
                        amount: amount,
                        period: currentPeriodForBet.toString(),
                        outcome: 'Pending',
                        winnings: 0,
                        timestamp: firebase.database.ServerValue.TIMESTAMP
                    };
                    await newBetRef.set(betData);
                    
                    activeBet = betData;
                    showAlert(`আপনি ${currentBetType}-এ ৳${amount} বেট করেছেন।`, 'Success');
                    betPopup.style.display = 'none';
                } else {
                    showAlert('আপনার অ্যাকাউন্টে পর্যাপ্ত ব্যালেন্স নেই।', 'Error', 'error');
                }
            } catch (error) {
                console.error("Bet placement failed:", error);
                showAlert('বেট করতে একটি সমস্যা হয়েছে। আবার চেষ্টা করুন।', 'Error', 'error');
            }
        });

        refreshBtn.addEventListener('click', () => {
            refreshBtn.classList.add('spinning');
            database.ref('users/' + currentUser.uid).once('value', snapshot => {
                if (snapshot.exists()) {
                    currentUserData = snapshot.val();
                    updateUIWithUserData(currentUserData);
                }
                 setTimeout(() => {
                    refreshBtn.classList.remove('spinning');
                    showAlert('Balance refreshed!', 'Success');
                }, 500);
            });
        });

        [closeResultBtn, resultPopup, alertOkBtn, alertPopup].forEach(el => {
            el.addEventListener('click', (e) => {
                if (e.target === el) {
                    resultPopup.style.display = 'none';
                    alertPopup.style.display = 'none';
                }
            });
        });
        
        historyTabButtons.forEach(button => {
            button.addEventListener('click', () => {
                historyTabButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
                historyTabPanels.forEach(panel => panel.classList.toggle('active', panel.id === `${button.dataset.tab}-panel`));
            });
        });
        
        // --- Deposit/Withdrawal Logic ---
        function switchPaymentMethod(method) {
            depositState.method = method;
            document.getElementById('bkash-tab').classList.toggle('active', method === 'bKash');
            document.getElementById('nagad-tab').classList.toggle('active', method === 'Nagad');
            loadPaymentNumbers();
        }

        function loadPaymentNumbers() {
            const container = document.getElementById('payment-number-container');
            container.innerHTML = '<div class="number-selection-grid"></div>';
            const grid = container.querySelector('.number-selection-grid');
            
            database.ref('paymentNumbers').orderByChild('type').equalTo(depositState.method).once('value', snapshot => {
                if (!snapshot.exists()) {
                    container.innerHTML = `<p>No ${depositState.method} numbers available.</p>`;
                    return;
                }
                snapshot.forEach(child => {
                    const numberData = child.val();
                    const card = document.createElement('div');
                    card.className = 'number-card';
                    card.innerHTML = `<div class="label">${numberData.label}</div><div class="number">${numberData.number}</div>`;
                    card.onclick = () => {
                        document.querySelectorAll('.number-card').forEach(c => c.classList.remove('selected'));
                        card.classList.add('selected');
                        depositState.selectedNumber = numberData;
                    };
                    grid.appendChild(card);
                });
            });
        }
        
        depositNextBtn.addEventListener('click', () => {
            const amount = parseFloat(document.getElementById('deposit-amount-input').value);
            if (!depositState.selectedNumber) {
                return showAlert('Please select a payment number.', 'Error', 'error');
            }
            if (isNaN(amount) || amount < (appSettings.minDeposit || 100)) {
                 return showAlert(`Minimum deposit amount is ৳${appSettings.minDeposit || 100}.`, 'Error', 'error');
            }
            
            depositState.amount = amount;
            document.getElementById('payment-method-label').textContent = depositState.method;
            document.getElementById('confirm-payment-number').textContent = depositState.selectedNumber.number;
            document.getElementById('confirm-payment-amount').textContent = `৳${amount}`;
            document.getElementById('txn-id-input').value = '';
            navigateToPage('deposit-confirm');
        });

        copyPaymentNumberBtn.addEventListener('click', () => {
            const number = document.getElementById('confirm-payment-number').textContent;
            navigator.clipboard.writeText(number).then(() => showAlert('Number copied!', 'Success'));
        });
        
        confirmDepositSubmitBtn.addEventListener('click', () => {
            const transactionId = document.getElementById('txn-id-input').value.trim();
             if (!transactionId) {
                return showAlert('Please enter the transaction ID.', 'Error', 'error');
            }
            
            database.ref('deposits').push({
                uid: currentUser.uid,
                amount: depositState.amount,
                method: depositState.method,
                agentNumber: depositState.selectedNumber.number,
                transactionId: transactionId,
                status: 'pending',
                createdAt: firebase.database.ServerValue.TIMESTAMP
            }).then(() => {
                showAlert('Deposit request submitted! It will be reviewed shortly.', 'Success');
                navigateToPage('wallet');
            }).catch(err => showAlert('Request failed: ' + err.message, 'Error', 'error'));
        });
        
        withdrawNavBtn.addEventListener('click', () => {
            // --- NEW: Check for banned status ---
            if (currentUserData && currentUserData.status === 'suspended') {
                showAlert(
                    'আপনার একাউন্টটি অবৈধ কার্যকলাপের জন্য সাসপেন্ড করা হয়েছে। আমাদের সিস্টেম আপনার আইপি ঠিকানা সনাক্ত করেছে। আপনি এই অ্যাকাউন্ট থেকে আর টাকা তুলতে পারবেন না।',
                    'অ্যাকাউন্ট সাসপেন্ডেড',
                    'error'
                );
                return; // Stop execution
            }
            // --- End of new check ---
            if (currentUserData && currentUserData.hasDeposited) {
                navigateToPage('withdraw');
            } else {
                showAlert('উইথড্র করার জন্য আপনাকে প্রথমে ডিপোজিট করতে হবে।', 'প্রথম ডিপোজিট প্রয়োজন', 'error');
            }
        });

        withdrawSubmitBtn.addEventListener('click', () => {
             // --- NEW: Check for banned status at the very beginning ---
            if (currentUserData && currentUserData.status === 'suspended') {
                showAlert(
                    'আপনার একাউন্টটি অবৈধ কার্যকলাপের জন্য সাসপেন্ড করা হয়েছে। আমাদের সিস্টেম আপনার আইপি ঠিকানা সনাক্ত করেছে। আপনি এই অ্যাকাউন্ট থেকে আর টাকা তুলতে পারবেন না।',
                    'অ্যাকাউন্ট সাসপেন্ডেড',
                    'error'
                );
                return; // Stop the entire withdrawal process
            }
            // --- End of new check ---
            
            const amount = parseFloat(document.getElementById('withdraw-amount').value);
            const method = document.getElementById('withdraw-method').value.trim();
            const number = document.getElementById('withdraw-account').value.trim();
            
            if (isNaN(amount) || amount < (appSettings.minWithdraw || 500)) {
                 return showAlert(`Minimum withdrawal is ৳${appSettings.minWithdraw || 500}.`, 'Error', 'error');
            }
            if (!method || !number) {
                 return showAlert('Please fill all fields.', 'Error', 'error');
            }
            
            const userWinningRef = database.ref(`users/${currentUser.uid}/winningBalance`);
            userWinningRef.once('value', snapshot => {
                const winningBalance = snapshot.val() || 0;
                if (winningBalance < amount) {
                    return showAlert('Insufficient winning balance to withdraw.', 'Error', 'error');
                }
                
                userWinningRef.transaction(balance => {
                    if (balance < amount) {
                        return;
                    }
                    return (balance || 0) - amount;
                }).then(result => {
                    if (!result.committed) {
                         return showAlert('Insufficient winning balance.', 'Error', 'error');
                    }
                    
                    database.ref('withdrawals').push({
                        uid: currentUser.uid,
                        amount, method, number,
                        status: 'pending',
                        createdAt: firebase.database.ServerValue.TIMESTAMP
                    }).then(() => {
                        showAlert('Withdrawal request submitted!', 'Success');
                        navigateToPage('wallet');
                    }).catch(err => {
                        // If saving withdrawal fails, refund the user
                        userWinningRef.transaction(balance => (balance || 0) + amount);
                        showAlert('Request failed: ' + err.message, 'Error', 'error');
                    });
                });
            });
        });

        document.addEventListener('DOMContentLoaded', () => {
             switchPaymentMethod('bKash');
        });

    </script>
</body>
</html>